<?php
session_start();

require 'bridge.php';

require 'session_timeout.php';

require 'config.php';

require 'user_info.php';



$msg='';
if(isset($_SESSION['buyairtime'])){
  $msg=$_SESSION['buyairtime'];
  unset($_SESSION['buyairtime']);
}


if(isset($_POST['network']) && $_POST['amount']!='' && $_POST['phone']!=''){
    extract($_POST);

    $network=mysqli_real_escape_string($linkage,$network);
    $amount=mysqli_real_escape_string($linkage,$amount);
    $phone=mysqli_real_escape_string($linkage,$phone);

    if(!preg_match('/^[0-9]{11,11}$/', $phone)){
        $_SESSION['buyairtime']="<span style='color:red'>Invalid phone number!</span>";
        header("location: buy-airtime");
        mysqli_close($linkage);
        exit;
    }

    if(!preg_match('/^[0-9]/', $amount)){
        $_SESSION['buyairtime']="<span style='color:red'>Invalid amount!</span>";
        header("location: buy-airtime");
        mysqli_close($linkage);
        exit;
    }

    if ($amount<0) {
        $amount=$amount*-1;
    }

    $amount=round($amount);

    if ($amount<50) {
        $_SESSION['buyairtime']="<span style='color:red'>Invalid amount!</span>";
        header("location: buy-airtime");
        mysqli_close($linkage);
        exit;
    }

    if ($network=='MTN VTU') {
        $disc=$mtnvtu;
    }

    // elseif ($network=='MTN SnS') {
    //     $disc=$mtnsns;
    // }

    elseif ($network=='Airtel VTU') {
        $disc=$airtelvtu;
    }

    elseif ($network=='Glo VTU') {
        $disc=$glovtu;
    }

    elseif ($network=='9mobile VTU') {
        $disc=$nmobilevtu;
    }

    $rate=(100-$disc)/100;
    $cost=$amount*$rate;

    try {
        $busy='';
        $lk=mysqli_query($linkage,"UPDATE users SET busy='$busy' WHERE uname='$uname'");
        // Before executing the select query, acquire a lock on the user's record
        $lockQuery = "SELECT bal,busy FROM users WHERE uname = '$uname' FOR UPDATE";
        $kk = mysqli_query($linkage, $lockQuery);

        if (!$kk) {
            throw new Exception("Lock failed: " . mysqli_error($linkage));
        }

    // $kk=mysqli_query($linkage, "SELECT * FROM users WHERE uname='$uname'") or die(mysqli_error($linkage));
       $jk=mysqli_fetch_array($kk);


        $newbal=$jk['bal']-$cost;
        mysqli_stmt_execute($query2) or die(mysqli_error($linkage));


        if ($cost>$jk['bal']) {
        	$newbal=$jk['bal'];

            mysqli_stmt_execute($query2) or die(mysqli_error($linkage));

            $_SESSION['buyairtime']="<span style='color:red'>Insufficient wallet balance!</span>";
            mysqli_commit($linkage);
            header("location: buy-airtime");
            exit;
        }


        $xnewbal= number_format((float)$newbal, 2, '.',',');
        $xbal= number_format((float)$jk['bal'], 2, '.',',');
        $xcost= number_format((float)$cost, 2, '.',',');

        date_default_timezone_set("Africa/Lagos");
        $dtime=date('Y-m-d H:i:s');

        $id=0;
        $ref= "A".substr('md5'((microtime(true)*10000).$phone.$cost), 15, 15);


        $desc= $network.' N'.$amount;

         if ($network=='MTN VTU') {
            $xxnetwork= "15";
        }

        // if ($network=='MTN SnS') {
        //     $xxnetwork= "MTN SnS";
        // }

        if ($network=='Airtel VTU') {
            $xxnetwork= "1";
        }

        if ($network=='Glo VTU') {
            $xxnetwork= "6";
        }

        if ($network=='9mobile VTU') {
            $xxnetwork= "2";
        }

        $status='';
        $apicode='';
        $apimessage='';




        if (($network=='MTN VTU') || ($network=='Airtel VTU') || ($network=='Glo VTU') || ($network=='9mobile VTU' )) {

            mysqli_stmt_execute($query3) or die(mysqli_error($linkage));

            $url = 'https://mobileairtimeng.com/httpapi/?userid='.$userid.'&pass='.$key.'&network='.$xxnetwork.'&phone='.$phone.'&amt='.$amount.'&user_ref='.$ref.'&jsn=json';

            $cUrlconnection = curl_init();
            curl_setopt($cUrlconnection, CURLOPT_URL, $url);
            curl_setopt($cUrlconnection, CURLOPT_RETURNTRANSFER, true);
            $data = curl_exec($cUrlconnection);
            curl_close($cUrlconnection);

            $xdata= json_decode($data, true);

            // //Test responses
            // $xdata['code']='100';
            // $xdata['message']='Recharge successful';

            if ($xdata['code']==100) {

                $status= "Completed";
                $apimessage=$xdata['message'];
                $apicode=$xdata['code'];


                mysqli_stmt_execute($query1) or die(mysqli_error($linkage));
                mysqli_stmt_execute($query4) or die(mysqli_error($linkage));

               // Email notification

                if ($enotif=='yes') {
                    $to = "$email";
                    $subj= "Transaction Notification";
                    $type='Debit';
                    $descr=$desc.' to '.$phone;
                    

                    sendenotif($fname,$type,$ref,$descr,$xcost,$xbal,$xnewbal,$dtime,$to,$subj,$sup_phone,$sup_email);

                }

                $resp= $xdata['message'];
                $_SESSION['buyairtime']="<span style='color:blue;'>".$xdata['message']."!<span>";
                header("location: buy-airtime");
                mysqli_commit($linkage);
                exit;

            }

            elseif ($xdata['code']=='') {

                $status= 'Pending';
                $apicode='';
                if (isset($xdata['message']) && $xdata['message']!='') {
                    $apimessage=$xdata['message'];
                }

                else {
                    $apimessage='None Received';
                }

                mysqli_stmt_execute($query1) or die(mysqli_error($linkage));
                mysqli_stmt_execute($query4) or die(mysqli_error($linkage));

               //Email notification

                if ($enotif=='yes') {
                    $to = "$email";
                    $subj= "Transaction Notification";
                    $type='Debit';
                    $descr=$desc.' to '.$phone;

                    sendenotif($fname,$type,$ref,$descr,$xcost,$xbal,$xnewbal,$dtime,$to,$subj,$sup_phone,$sup_email);

                }


                $_SESSION['buyairtime']="<span style='color:blue;'>Recharge pending!</span>";
                mysqli_commit($linkage);
                header("location: buy-airtime");
                exit;

            }

            else {

                $status='Failed';

                if (isset($xdata['code'])) {
                    $apicode=$xdata['code'];
                    $apimessage=$xdata['message'];
                    $notice= $apimessage;
                }

                else {
                    $apimessage='None Received';
                    $notice='Recharge failed';
                }


                mysqli_stmt_execute($query4) or die(mysqli_error($linkage));

                //reversal starts

                trans_rollback($linkage,$uname,$cost);


                //reversal ends


                $_SESSION['buyairtime']="<span style='color: red;'>".$notice."</span>";
                mysqli_commit($linkage);
                header("location: buy-airtime");
                exit;

            }

        }

    }

    catch (Exception $e) {
    // Rollback the transaction in case of an error
    mysqli_rollback($linkage);
    //exit("An error occurred: " . $e->getMessage());

    }

    // elseif ($network=='MTN SnS') {

    //     if ($amount<100 || $amount>5000){
    //         $_SESSION['buyairtime']="<p style='color:red'>MTN SnS minimum amount is 100 and maximum amount is 5000!</p>";
    //         header("location: buy-airtime");
    //         mysqli_close($linkage);
    //         exit;

    //     }

    //     mysqli_stmt_execute($query3) or die(mysqli_error($linkage));

    //     $url = 'https://mobileairtimeng.com/httpapi/msharesell?userid='.$userid.'&pass='.$key.'&phone='.$phone.'&amt='.$amount.'&user_ref='.$ref.'&jsn=json';


    //     $cUrlconnection = curl_init();
    //     curl_setopt($cUrlconnection, CURLOPT_URL, $url);
    //     curl_setopt($cUrlconnection, CURLOPT_RETURNTRANSFER, true);
    //     $data = curl_exec($cUrlconnection);
    //     curl_close($cUrlconnection);

    //     $xdata= json_decode($data, true);

    //     if ($xdata['code']==100) {

    //         $status= "Completed";
    //         $apimessage=$xdata['message'];
    //         $apicode=$xdata['code'];

    //         mysqli_stmt_execute($query1) or die(mysqli_error($linkage));
    //         mysqli_stmt_execute($query4) or die(mysqli_error($linkage));

    //        //Email notification

    //         if ($enotif=='yes') {
    //             $to = "$email";
    //             $subj= "Transaction Notification";
    //             $type='Debit';
    //             $descr=$desc.' to '.$phone;

    //             sendenotif($fname,$type,$ref,$descr,$xcost,$xbal,$xnewbal,$dtime,$to,$subj,$sup_phone,$sup_email);

    //         }


    //         $_SESSION['buyairtime']="<p style='color:blue'>".$xdata['message']."!</p>";
    //         header("location: buy-airtime");
    //         mysqli_close($linkage);
    //         exit;

    //     }

    //     elseif ($xdata['code']=='') {

    //         $status= 'Pending';
    //         $apicode='';
    //         if (isset($xdata['message']) && $xdata['message']!='') {
    //             $apimessage=$xdata['message'];
    //         }

    //         else {
    //             $apimessage='None Received';
    //         }

    //         mysqli_stmt_execute($query1) or die(mysqli_error($linkage));
    //         mysqli_stmt_execute($query4) or die(mysqli_error($linkage));

    //        //Email notification

    //         if ($enotif=='yes') {
    //             $to = "$email";
    //             $subj= "Transaction Notification";
    //             $type='Debit';
    //             $descr=$desc.' to '.$phone;

    //             sendenotif($fname,$type,$ref,$descr,$xcost,$xbal,$xnewbal,$dtime,$to,$subj,$sup_phone,$sup_email);

    //         }


    //         $_SESSION['buyairtime']="<p style='color:blue'>Recharge successful!</p>";
    //         header("location: buy-airtime");
    //         mysqli_close($linkage);
    //         exit;

    //     }

    //     else {

    //         $status='Failed';
    //         if (isset($xdata['code'])) {
    //             $apicode=$xdata['code'];
    //             $apimessage=$xdata['message'];
    //         }

    //         else {
    //             $apimessage='None Received';
    //         }

    //         mysqli_stmt_execute($query4) or die(mysqli_error($linkage));

    //         $_SESSION['buyairtime']="<p style='color:red'>Failed!</p>";
    //         header("location: buy-airtime");
    //         mysqli_close($linkage);
    //         exit;

    //     }


    // }

}


?>

<!DOCTYPE html>

<html lang="en">

<head>
	<meta charset="UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<title>Buy Airtime | <?php echo @$site_name ?></title>
	<link rel="stylesheet" href="style" />
	<!-- Fontawesome CDN Link -->

	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
  <!-- <link rel="stylesheet" href="style" /> -->
  <link rel="stylesheet" href="../assets/css/theme">

  <!-- Links to Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="../assets/favicon/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="../assets/favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="../assets/favicon/favicon-16x16.png">

  <link rel="stylesheet" href="../assets/css/loopple/loopple.css">
  <!--Font Awesome styles -->
  <link href="../assets/fonts/fontawesome/css/all.css?v=1" rel="stylesheet">
</head>

<body class="g-sidenav-show bg-gray-100">
	<?php
		include 'aside.php';
	?>

	<main class="main-content" id="panel">
	<?php
		include 'navbar.php';
	?>
		<div class="top-link bg-white my-2 p-2">
			<a href="dashboard">
			<i class="fas fa-arrow-left"></i>
			Buy Airtime</a>
		</div>
		<div class="card-content mt-3">
			<div class="card col-sm-6 mx-auto shadow-sm p-3">
				<form id="buyairtime" name="buyairtime" method="post">
					<h5 class="pb-3">Airtime</h5>
                    <div class="airtimebalcheck">
                       	<font style="color: #FAB304;"><b><u>Ba</b></font><font style="color: #FA3939;"><b>la</b></font><font style="color: #02FC15;"><b>n</b></font><font style="color: #05390C;"><b>ce</u>-</b></font> *310#
                    </div>

                        <div class="form-msg mb-1" style="display: flex; justify-content: center;">
                            <p class="fw-bold fs-6 mb-0">
                                <?php echo @$msg ?>
                            </p>
                        </div>
					<div class="mb-2">
						<label for="network" class="form-label">Select Network</label><br>
                        <select class="form-select" id="network" name="network" required="" onChange="chkamt()">
                        	<option value="" selected="">Select Network</option>
                        	<option value="MTN VTU">MTN VTU</option>
                        	<!-- <option value="MTN SnS">MTN Share & Sell</option> -->
                            <option value="Airtel VTU">AIRTEL VTU</option>
                            <option value="Glo VTU">GLO VTU</option>
                            <option value="9mobile VTU">9MOBILE VTU</option>
                        </select>

					</div>
					<div class="mb-2">
						<label for="amount" class="form-label">Amount (&#8358;)</label>
						<input type="number" class="form-control" id="amount" name="amount" placeholder="Minimum of &#8358;50" onKeyUp="chkamt()">
					</div>
					<div class="mb-2">
						<label for="payamt" class="form-label">Bill</label>
						<input type="text" class="form-control" type="text" id="payamt" name="payamt" placeholder="&#8358;0.00" readonly="">
					</div>

					<div class="mb-2">
						<label for="phone" class="form-label">Phone Number</label>
						<input type="number" class="form-control" id="phone" name="phone" data-maxlength="11" oninput="this.value=this.value.slice(0,this.dataset.maxlength)">
					</div>

					<button type="button" class="btn btn-primary" id="loginbtn" name="loginbtn" onClick="sendairtime()">Buy Airtime</button>
				</form>
			</div>
		</div>
	</main>




	<script src="main.js"></script>
  <script src="../assets/js/popper.min.js"></script>
  <script src="../assets/js/bootstrap.min.js"></script>
  <script src="../assets/js/perfect-scrollbar.min.js"></script>
  <script src="../assets/js/smooth-scrollbar.min.js"></script>
  <script src="../assets/js/vtuportal-dashboard.min.js"></script>

	<script>
        function chkamt() {
        var chkamount = document.getElementById("amount").value;
        var network = document.getElementById("network").value;

            if (chkamount<'0' && chkamount!='') {
                chkamount=chkamount*-1;
                document.getElementById('amount').value=chkamount;
            }

            if (network=='MTN VTU') {
                var rate="<?php echo $mtnvtu; ?>";
                pay='₦'+(chkamount*((100-rate)/100)).toFixed(2);
            }

            if (network=='Airtel VTU') {
                var rate="<?php echo $airtelvtu; ?>";
                pay='₦'+(chkamount*((100-rate)/100)).toFixed(2);
            }

            if (network=='Glo VTU') {
                var rate="<?php echo $glovtu; ?>";
                pay='₦'+(chkamount*((100-rate)/100)).toFixed(2);
            }

            if (network=='9mobile VTU') {
                var rate="<?php echo $nmobilevtu; ?>";
                pay='₦'+(chkamount*((100-rate)/100)).toFixed(2);
            }

            if (network=='') {
                pay='';
            }

            document.getElementById('payamt').value=pay;
            exit;
        }


      function sendairtime() {
        var network = document.getElementById("network").value;
        var amount = document.getElementById("amount").value;
        var phone = document.getElementById("phone").value;

        if (network=='') {
            alert ('Please select network!');
            exit;
        }

        if (amount=='' || amount<50) {
            alert ('Please enter a valid amount!');
            exit;
        }

        if (phone=='') {
            alert ('Please enter phone number!');
            exit;
        }

        if (phone.length<11) {
            alert ('Phone number must be 11 digits!');
            exit;
        }


        var jose=confirm("Do you wish to proceed? This cannot be undone!");
        if (jose==1) {
        document.getElementById('loginbtn').innerHTML='Sending...';
        document.buyairtime.submit();
        }
      }

	</script>

</body>

</html>